/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.client;

import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.config.init.FLMath;
import io.github.bumblesoftware.fastload.config.screen.BuildingTerrainScreen;
import io.github.bumblesoftware.fastload.init.Fastload;
import io.github.bumblesoftware.fastload.util.TickTimer;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_437;

public final class FLClientHandler {
    private static final class_310 client = class_310.method_1551();
    private static boolean playerReady = false;
    private static boolean playerJoined = false;
    private static boolean justLoaded = false;
    private static boolean showRDDOnce = false;
    private static boolean isBuilding = false;
    private static boolean closeBuild = false;
    private static Float oldPitch = null;
    private static Integer oldChunkLoadedCountStorage = null;
    private static Integer oldChunkBuildCountStorage = null;
    private static int preparationWarnings = 0;
    private static int buildingWarnings = 0;
    public static final TickTimer CLIENT_TIMER = new TickTimer(FLClientEvents.RENDER_TICK_EVENT);

    public static void init() {
        FLClientHandler.registerEvents();
    }

    private static class_4184 getCamera() {
        return FLClientHandler.client.field_1773.method_19418();
    }

    public static void log(String toLog) {
        Fastload.LOGGER.info(toLog);
    }

    private static void logRenderDistanceDifference() {
        if (!FLMath.getPreRenderRadius().equals(FLMath.getPreRenderRadius(true))) {
            FLClientHandler.log("Pre-rendering radius changed to " + FLMath.getPreRenderRadius() + " from " + FLMath.getPreRenderRadius(true) + " to protect from chunks not loading past your given render distance. To resolve this, please adjust your render distance accordingly");
        }
    }

    private static void logPreRendering(int chunkLoadedCount) {
        FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getPreRenderArea());
        FLClientHandler.log("Loaded Chunks: " + chunkLoadedCount);
    }

    private static void logBuilding(int chunkBuildCount, int chunkBuildCountGoal) {
        FLClientHandler.log("Goal (Built Chunks): " + chunkBuildCountGoal);
        FLClientHandler.log("Chunk Build Count: " + chunkBuildCount);
    }

    private static void stopBuilding(int chunkLoadedCount, int chunkBuildCount, int chunkBuildCountGoal) {
        if (playerJoined) {
            closeBuild = true;
            if (FLMath.getDebug().booleanValue()) {
                FLClientHandler.logBuilding(chunkBuildCount, chunkBuildCountGoal);
                FLClientHandler.logPreRendering(chunkLoadedCount);
            }
            isBuilding = false;
            if (!FLClientHandler.client.field_1695) {
                CLIENT_TIMER.setTime(20);
                if (FLMath.getDebug().booleanValue()) {
                    FLClientHandler.log("Temporarily Cancelling Pause Menu to enable Renderer");
                }
            }
            assert (FLClientHandler.client.field_1724 != null);
            if (oldPitch != null) {
                FLClientHandler.getCamera().method_19325(FLClientHandler.client.field_1724.method_36454(), oldPitch.floatValue());
                if (FLClientHandler.client.field_1724.method_36455() != oldPitch.floatValue()) {
                    FLClientHandler.client.field_1724.method_36457(oldPitch.floatValue());
                }
                oldPitch = null;
            }
            playerJoined = false;
            oldChunkLoadedCountStorage = 0;
            oldChunkBuildCountStorage = 0;
            System.gc();
            client.method_1507(null);
        }
    }

    private static void registerEvents() {
        FLClientEvents.CLIENT_PLAYER_INIT_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (FLMath.getDebug().booleanValue()) {
                Fastload.LOGGER.info("shouldLoad = true");
            }
            playerReady = true;
            return null;
        });
        FLClientEvents.PLAYER_JOIN_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (FLMath.getDebug().booleanValue()) {
                Fastload.LOGGER.info("playerJoined = true");
            }
            playerJoined = true;
            return null;
        });
        FLClientEvents.SET_SCREEN_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (eventContext.screen() == null) {
                isBuilding = false;
                playerReady = false;
                justLoaded = false;
                showRDDOnce = false;
                oldPitch = null;
            }
            return null;
        });
        FLClientEvents.SET_SCREEN_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (CLIENT_TIMER.isReady() && eventContext.screen() instanceof class_433 && !FLClientHandler.client.field_1695) {
                if (FLMath.getDebug().booleanValue()) {
                    FLClientHandler.log(Integer.toString(CLIENT_TIMER.getTime()));
                }
                eventContext.ci().cancel();
                client.method_1507(null);
            }
            return null;
        });
        FLClientEvents.SET_SCREEN_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (eventContext.screen() instanceof BuildingTerrainScreen && FLMath.getDebug().booleanValue()) {
                FLClientHandler.log("Successfully Initiated Building Terrain");
            }
            return null;
        });
        FLClientEvents.SET_SCREEN_EVENT.register(2L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (eventContext.screen() instanceof class_435 && FLMath.getCloseUnsafe().booleanValue()) {
                eventContext.ci().cancel();
                if (FLMath.getDebug().booleanValue()) {
                    FLClientHandler.log("Progress Screen Successfully Cancelled");
                }
            }
            return null;
        });
        FLClientEvents.SET_SCREEN_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (eventContext.screen() instanceof class_434 && playerReady && playerJoined) {
                if (FLMath.getDebug().booleanValue()) {
                    FLClientHandler.log("Downloading Terrain Accessed!");
                }
                playerReady = false;
                justLoaded = true;
                showRDDOnce = true;
                if (FLMath.getCloseSafe().booleanValue()) {
                    eventContext.ci().cancel();
                    if (FLMath.getDebug().booleanValue()) {
                        FLClientHandler.log("Preparing to replace Download Terrain with Building Terrain");
                    }
                    if (FLMath.getDebug().booleanValue()) {
                        FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getPreRenderArea());
                    }
                    isBuilding = true;
                    client.method_1507((class_437)new BuildingTerrainScreen());
                    System.gc();
                } else if (FLMath.getCloseUnsafe().booleanValue()) {
                    playerJoined = false;
                    if (FLMath.getDebug().booleanValue()) {
                        FLClientHandler.log("Successfully Skipped Downloading Terrain Screen!");
                    }
                    eventContext.ci().cancel();
                    client.method_1507(null);
                    CLIENT_TIMER.setTime(20);
                }
            }
            return null;
        });
        FLClientEvents.PAUSE_MENU_EVENT.register(1L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (justLoaded) {
                if (FLClientHandler.client.field_1695) {
                    justLoaded = false;
                } else {
                    justLoaded = false;
                    eventContext.ci().cancel();
                    if (FLMath.getDebug().booleanValue()) {
                        FLClientHandler.log("Pause Menu Cancelled");
                    }
                }
            }
            return null;
        });
        FLClientEvents.RENDER_TICK_EVENT.register(10L, (eventContext, abstractEvent, closer, eventArgs) -> {
            if (showRDDOnce) {
                FLClientHandler.logRenderDistanceDifference();
                showRDDOnce = false;
            }
            if (isBuilding && FLClientHandler.client.field_1687 != null) {
                if (FLClientHandler.client.field_1724 != null) {
                    if (oldPitch == null) {
                        oldPitch = Float.valueOf(FLClientHandler.client.field_1724.method_36455());
                    }
                    FLClientHandler.client.field_1724.method_36457(0.0f);
                    if (FLMath.getDebug().booleanValue()) {
                        FLClientHandler.log("Pitch:" + oldPitch);
                    }
                }
                int chunkLoadedCount = FLClientHandler.client.field_1687.method_2935().method_14151();
                int chunkBuildCount = FLClientHandler.client.field_1769.method_3246();
                double FOV = ((Integer)FLClientHandler.client.field_1690.method_41808().method_41753()).intValue();
                double chunkBuildCountGoal = FOV / 180.0 * FLMath.getPreRenderArea().doubleValue();
                int oldPreparationWarningCache = preparationWarnings;
                int oldBuildingWarningCache = buildingWarnings;
                if (FLMath.getDebug().booleanValue()) {
                    FLClientHandler.logPreRendering(chunkLoadedCount);
                    FLClientHandler.logBuilding(chunkBuildCount, (int)chunkBuildCountGoal);
                }
                if (oldChunkLoadedCountStorage != null && oldChunkBuildCountStorage != null) {
                    if (oldChunkLoadedCountStorage == chunkLoadedCount) {
                        ++preparationWarnings;
                    }
                    if (oldChunkBuildCountStorage == chunkBuildCount) {
                        ++buildingWarnings;
                    }
                    if (!(buildingWarnings < FLMath.getChunkTryLimit() && preparationWarnings < FLMath.getChunkTryLimit() || FLMath.getForceBuild().booleanValue())) {
                        buildingWarnings = 0;
                        preparationWarnings = 0;
                        FLClientHandler.log("Pre-loading is taking too long! Stopping...");
                        FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount, (int)chunkBuildCountGoal);
                    }
                    if (!closeBuild) {
                        int spamLimit = 2;
                        if (preparationWarnings > 0) {
                            if (oldPreparationWarningCache == preparationWarnings && preparationWarnings > 2) {
                                FLClientHandler.log("FL_WARN# Same prepared chunk count returned " + preparationWarnings + " time(s) in a row!");
                                if (!FLMath.getForceBuild().booleanValue()) {
                                    FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, pre-loading would've stopped");
                                }
                                if (FLMath.getDebug().booleanValue()) {
                                    FLClientHandler.logPreRendering(chunkLoadedCount);
                                }
                            }
                            if (chunkLoadedCount > oldChunkLoadedCountStorage) {
                                preparationWarnings = 0;
                            }
                        }
                        if (buildingWarnings > 0) {
                            if (oldBuildingWarningCache == buildingWarnings && buildingWarnings > 2) {
                                FLClientHandler.log("FL_WARN# Same built chunk count returned " + buildingWarnings + " time(s) in a row");
                                if (!FLMath.getForceBuild().booleanValue()) {
                                    FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, pre-loading would've stopped");
                                }
                                if (FLMath.getDebug().booleanValue()) {
                                    FLClientHandler.logPreRendering(chunkLoadedCount);
                                }
                            }
                            if (chunkBuildCount > oldChunkBuildCountStorage) {
                                buildingWarnings = 0;
                            }
                        }
                    }
                }
                oldChunkLoadedCountStorage = chunkLoadedCount;
                oldChunkBuildCountStorage = chunkBuildCount;
                if (chunkLoadedCount >= FLMath.getPreRenderArea() && (double)chunkBuildCount >= chunkBuildCountGoal) {
                    FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount, (int)chunkBuildCountGoal);
                    FLClientHandler.log("Successfully pre-loaded the world! Stopping...");
                }
            }
            return null;
        });
    }
}

